/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.pet_cemetery.common.advancement;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.loot.LootContext;

public class RespawnPetTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final ResourceLocation ID = new ResourceLocation("pet_cemetery", "respawn_pet");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public TriggerInstance createInstance(JsonObject jsonObject, EntityPredicate.Composite player, DeserializationContext context) {
        EntityPredicate.Composite pet = EntityPredicate.Composite.m_36677_((JsonObject)jsonObject, (String)"pet", (DeserializationContext)context);
        EntityPredicate.Composite respawnedPet = EntityPredicate.Composite.m_36677_((JsonObject)jsonObject, (String)"respawned_pet", (DeserializationContext)context);
        return new TriggerInstance(player, pet, respawnedPet);
    }

    public void trigger(ServerPlayer player, Animal pet, Animal respawnedPet) {
        LootContext petContext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)pet);
        LootContext respawnedPetContext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)respawnedPet);
        this.m_66234_(player, instance -> instance.matches(petContext, respawnedPetContext));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate.Composite pet;
        private final EntityPredicate.Composite respawnedPet;

        public TriggerInstance(EntityPredicate.Composite player, EntityPredicate.Composite pet, EntityPredicate.Composite respawnedPet) {
            super(ID, player);
            this.pet = pet;
            this.respawnedPet = respawnedPet;
        }

        public static TriggerInstance respawnPet() {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, EntityPredicate.Composite.f_36667_, EntityPredicate.Composite.f_36667_);
        }

        public static TriggerInstance respawnPet(EntityPredicate entity) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, EntityPredicate.Composite.f_36667_, EntityPredicate.Composite.m_36673_((EntityPredicate)entity));
        }

        public boolean matches(LootContext petContext, LootContext respawnedPetContext) {
            if (!this.pet.m_36681_(petContext)) {
                return false;
            }
            return this.respawnedPet.m_36681_(respawnedPetContext);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            jsonObject.add("pet", this.pet.m_36675_(context));
            jsonObject.add("respawned_pet", this.respawnedPet.m_36675_(context));
            return jsonObject;
        }
    }
}

